withdrawals.controllers.module('delete-modal',
	[],
	() => {
		return {
			vue: true,
			name: 'gx-delete-modal',
			template: '#delete-modal',
			parent: 'gx-withdrawals-overview',
			data: () => ({
				lang: {
					title: jse.core.lang.translate('delete_modal_title', 'withdrawals'),
					text: jse.core.lang.translate('delete_modal_text', 'withdrawals'),
					close: jse.core.lang.translate('delete_modal_close', 'withdrawals'),
					confirm: jse.core.lang.translate('delete_modal_confirm', 'withdrawals'),
					labels: {
						id: jse.core.lang.translate('delete_modal_label_id', 'withdrawals'),
						date: jse.core.lang.translate('delete_modal_label_date', 'withdrawals'),
						order: jse.core.lang.translate('delete_modal_label_order', 'withdrawals'),
						customer: jse.core.lang.translate('delete_modal_label_customer', 'withdrawals'),
					}
				},
			}),
			props: {
				withdrawal: {
					type: Object,
				}
			},
			watch: {
				withdrawal(newVal) {
					if (newVal !== undefined) {
						$('.delete-modal.modal').modal('show');
					}
				}
			},
			methods: {
				confirm() {
					jse.libs.xhr.post({
						url: './admin.php?do=Withdrawals/DeleteWithdrawal',
						data: {id: this.withdrawal.id}
					}).done(response => {
						this.$emit('reload-overview');
					}).fail((response) => {
						console.error('Could not load withdrawal details.', response);
						jse.libs.info_messages.addError(jse.core.lang.translate('error_could_not_delete_withdrawal', 'withdrawals'));
					});
					$('.delete-modal.modal').modal('hide');
				},
			},
			init: done => done()
		}
	});